#=============================================================================================
# The main functions for generating the results of the RPD module
# Dependencies:
# "SPD_util.R"  sourced by describe.selected.genes
# "source - utils.r" sourced by store.SPD.results
#=============================================================================================

# This is the main function of the SPD.module. It is a wrapper around describe.selected.gene (plot rendering) and store.SPD.results (plot storing)
# functions it returns a list of lists (tree) containing the uri to the plots. The structure of this list of lists encodes the html hierarchy

run.RPD <- function(dat, 
                    prb.annots,
                    smp.annots,
                    prb.grp.members,
                    var.to.describe.probes.by = NULL,
                    var.to.trend.by = NULL,
                    var.to.order.obs.by = NULL,
                    var.to.stratify.trend.by = NULL,
                    color.cat.annots,
                    file.extension = c("png","pdf","tiff","jpg","bmp"),
                    path.to.RPD.results){
  
  source("./R_source/source - SPD_util.R")
  
  RPD <- describe.related.probes(dat = dat,
                                 prb.annots = prb.annots,
                                 smp.annots = smp.annots,
                                 prb.grp.members = prb.grp.members,
                                 var.to.describe.probes.by = var.to.describe.probes.by,
                                 var.to.trend.by = var.to.trend.by,
                                 var.to.order.obs.by = var.to.order.obs.by,
                                 var.to.stratify.trend.by = var.to.stratify.trend.by)
  
  # Modify colors
  #--------------
  plots.to.modify.col <- c("cor.plots")
  for(plt.type  in plots.to.modify.col){
    if(is.null(RPD[[plt.type]]))
      next
    for(annot.i in names(RPD[[plt.type]])){
      for(plt in names(RPD[[plt.type]][[annot.i]])){
        if(!"SPD" %in% class(RPD[[plt.type]][[annot.i]][[plt]]))
          stop("RPD[[plt.type]][[annot.i]][[plt]] is not a SPD plot")
        p <- RPD[[plt.type]][[annot.i]][[plt]]
        tmp <- try(SPD.plot.chnage.color(p=p,colors = unname(color.cat.annots[[annot.i]][SPD.plot.get.color.levels(p)])))

        if(all(class(tmp) != "try-error"))
          RPD[[plt.type]][[annot.i]][[plt]] <- tmp
      
      }
    }
  }
  
  file.extension <- unique(c("png",file.extension))
  for(flx in file.extension){
    tmp <- store.SPD.results(SPD = RPD,file.extension = flx, path.to.SPD.results = path.to.RPD.results)
    if(flx == "png")
      RPD.dir <- tmp
  }
  
  
  return(RPD.dir)  
  
}


describe.related.probes <- function(dat, 
                                    prb.annots,
                                    smp.annots,
                                    prb.grp.members,
                                    var.to.describe.probes.by = NULL,
                                    var.to.trend.by = NULL,
                                    var.to.order.obs.by = NULL,
                                    var.to.stratify.trend.by = NULL){
  
  
  # hard-coded annotation var names
  #--------------------------------
  var.probe.names <- "Probe.Label"
  var.probe.types <- "Analyte.Type"
  var.probe.related <- "Related.Probes"
  
  #   if(is.NULL(pannot$Related.Probes)){
  #     wtmp <- "3D Biology is aborted: Related probes are not identified within the probe annotation provided. Populate the relationship information in Related.Probes column of the probe annotation\n"
  #     warnings.paragraph <- paste(warnings.paragraph,"Warning:",wtmp,"\n")
  #   }
  
  
  # validate the input
  #-------------------
  if(!var.probe.names %in% colnames(prb.annots))
    stop(paste(var.probe.names, "needs to be in columns of prb.annots"))
  
  if(!var.probe.types %in% colnames(prb.annots))
    stop(paste(var.probe.types,"needs to be in columns of prb.annots"))
  
  if(!var.probe.related %in% colnames(prb.annots)){
    stop(paste(var.probe.related,"needs to be in columns of prb.annots"))
    warnings.paragraph <- paste(warnings.paragraph,"Warning:",wtmp,"\n")
  }
  
  
  if(!is.data.frame(smp.annots))
    stop("smp.annots need to be a data.frame")
  
  if(sum(!complete.cases(smp.annots))!= 0)
    warning("There are missing annotations: samples with missing annotation will be disregarded")
  
  if(!all.equal(rownames(smp.annots),rownames(dat)))
    stop("rownames of the smp.annots should match those of the dat")

  if(any(!prb.grp.members %in% colnames(dat)))
    stop(paste("Probe(s)",prb.grp.members[(!prb.grp.members %in% colnames(dat))],"could not be found in the dataset",sep=" "))
  
  
  if(is.null(var.to.describe.probes.by))
    var.to.describe.probes.by <- "no_annotation"
  
  if(is.null(var.to.stratify.trend.by))
    var.to.stratify.trend.by <- "no_annotation"
  
  
  # probe annotation variables for convenience
  #-------------------------------------------
  probe.names <- prb.annots[,var.probe.names,drop=F]
  probe.types <- prb.annots[,var.probe.types,drop=F]
  
  
  # Trend plot options validation
  generate.trend.plot <- FALSE
  if(!is.null(var.to.trend.by) & !is.null(var.to.order.obs.by)){
    if(!var.to.trend.by %in% colnames(smp.annots))
      stop("var.to.trend.by needs to be in the colnames of smp.annots")
    if(!var.to.order.obs.by %in% colnames(smp.annots))
      stop("var.to.order.obs.by needs to be in the colnames of smp.annots")
    generate.trend.plot <- TRUE
  }

  
  # Get the groups of related probes
  # NOTE: the assumption here is that the column "Relate.Probes" contains all related probes
  #       separated by as many degrees as needed. Example: if A relates to B and B relates to C then "Related.Probes" column
  #       for A should contain both B and C. If this logic ever is not valid, then the related probes sets will have missing elements!
  #---------------------------------------------------------------------------------------------------------
  #   analytes.present <- levels(prb.annots[,var.probe.types])
  #   related.prbs <- unlist(strsplit(as.character(prb.annots$ProbeID[(prb.annots[,var.probe.related])!=""]),split = ";"))
  #   
  #   if(is.null(related.prbs))
  #     return(NULL)
  #   
  #   prbs.matched <- NULL
  #   prb.groups <- list()
  #   for(rp in related.prbs ){
  #     if(rp %in% prbs.matched){
  #       #cat(rp," already counted\n")
  #       next
  #     }
  #     
  #     prb.groups[[rp]] <- unlist(strsplit(as.character(prb.annots[as.character(prb.annots$ProbeID) == rp,"Related.Probes"]),split = ";"))
  #     prbs.matched <- c(prbs.matched,rp,prb.groups[[rp]])
  #   }
  
  # Get probe groups
  prb.groups <- list()
  tmp.prbs <- prb.grp.members
  while(length(tmp.prbs)>0){
    prb.i <- tmp.prbs[1]
    prb.groups[[prb.i]] <- setdiff(c(prb.i,unlist(lapply(prb.annots[prb.i,"Related.Probes"], function(x) strsplit(x,split = ";")))),"")
    tmp.prbs <- setdiff(tmp.prbs,prb.groups[[prb.i]])
  }
  rm(tmp.prbs)
  
  
  # Initiate plot lists
  #--------------------
  cor.plots <- parcor.plots <- list()
  length(cor.plots) <- length(parcor.plots)  <-  length(var.to.describe.probes.by)
  names(cor.plots)  <- names(parcor.plots)  <- var.to.describe.probes.by
  
  
  trend.plots <- list()
  length(trend.plots) <- length(var.to.stratify.trend.by) # currently 1
  names(trend.plots) <- var.to.stratify.trend.by
  
  for(grp in names(prb.groups)){
    probe.ids.to.describe <- prb.groups[[grp]]
    
    for(annot.i in var.to.describe.probes.by){
      
      #cor.plots
      #----------
      # update status report
      cat(paste("document.write('<p>Creating corrlation plots for",paste(probe.ids.to.describe,collapse = ","),ifelse(annot.i %in% colnames(smp.annots),paste("stratified by",annot.i),""),"</p>');"), file=paste(path.inc,"//status.js",sep=""),append=TRUE)
      
      cor.plots[[annot.i]][[grp]] <- corplot(dat = dat,
                                             probe.ids = probe.ids.to.describe,
                                             probe.names = probe.names,
                                             probe.types = probe.types,
                                             smp.annot = if(annot.i %in% colnames(smp.annots)){smp.annots[,annot.i,drop=F]}else{NULL})
    }
    
    
    # Trend analysis
    #---------------
    if(generate.trend.plot){
      
      #print(probe.i)
      
      # update status report
      #cat(paste("document.write('<p>Creating trend plots for",probe.i,"</p>');"), file=paste(path.inc,"//status.js",sep=""),append=TRUE)
      
      trend.plots[[var.to.stratify.trend.by]][[grp]] <- trend.plot(dat = dat,
                                                                   probe.ids = probe.ids.to.describe,
                                                                   probe.names = probe.names,
                                                                   probe.types = probe.types,
                                                                   smp.annot = smp.annots,
                                                                   var.to.trend.by = var.to.trend.by,
                                                                   var.to.order.obs.by = var.to.order.obs.by,
                                                                   var.to.stratify.by = var.to.stratify.trend.by,
                                                                   adj.to.tmin = T,
                                                                   xlab = var.to.order.obs.by)
      
    }
    
  }
  
  RPD <- list(cor.plots = cor.plots,trend.plots = trend.plots)
  return(RPD)
  
}


# This function accesses the argument file and validates its SPD.annot.args contents for SPD run
# @ dat: the data.frame containing the data to be analyzed by SPD
# @ smp.annots: sample annotation file
# @ SPD.annot.args: a character verctor contraining all SPD related argumnets (i.e. colnames of annotations to be used in SPD run)
# @ SPD.prb.names.arg: names of the variable contraining the names of the probes to be described within the argument file
# value:
# warnings to be appended to the list of warnings to be displayed.

validate.RPD.arguments <- function(dat,
                                   smp.annots,
                                   prb.annots,
                                   RPD.panot.args = NULL,#"RPDarg.rp.identifier.column",
                                   RPD.annot.args = c("RPDarg.describe.probes.by",
                                                    "RPDarg.order.expression.trend.by",
                                                    "RPDarg.trend.expression.by",
                                                    "RPDarg.stratify.expression.trend.by",
                                                    #"RPDarg.interactnet.stratifyby",
                                                    "RPDarg.interactnet.adjustfor")){
  
  var.to.message <- c(RPDarg.describe.probes.by = "to describe probe(s) by",
                      #RPDarg.rp.identifier.column = "to pair probe(s) by",
                      RPDarg.interactnet.adjustfor = "to adjust interactnet for",
                      #RPDarg.interactnet.stratifyby = "to staratify interactnet by",
                      RPDarg.order.expression.trend.by = "to order expression trend by",
                      RPDarg.stratify.expression.trend.by = "to stratify expression trend by",
                      RPDarg.trend.expression.by = "to trend expression by")
  
  
  wtmp <- NULL
  
  tmp.env <- new.env()
  source("./arguments.r",local = tmp.env)
  
  
  for(arg.i in c(RPD.annot.args,RPD.panot.args)){
    
    tmp.annot.names <- get(arg.i,envir = tmp.env)
    
    # ignore variable if it is NULL or NA
    if(length(tmp.annot.names)<2){
      if(is.null(tmp.annot.names))
        next
      if(is.na(tmp.annot.names))
        next
    }
    
    # for non-NULL non-NA validate the argument
    #------------------------------------------
    tmp.annot <- smp.annots
    if(arg.i %in% RPD.panot.args)
      tmp.annot <- prb.annots
    tmp.annot.renames <- reconcile.variables.with.annot(annot = tmp.annot,
                                                        variables = tmp.annot.names,
                                                        variabletypes=NULL,
                                                        referencelevels=NULL)$variables
    
    assign(arg.i,value = tmp.annot.renames,envir = globalenv())
    
    if(length(get(arg.i))==0){
      wtmp <- paste(tmp.annot.names,"is not a valid annotation to",var.to.message[arg.i],"and is removed from SPD analysis")
      warning(wtmp)
      wtmp <- paste(wtmp,"Warning:",wtmp,"\n")
      
      assign(arg.i,value = NULL,envir = globalenv())
    }
    
    # Generate warning when annotation contains NA
    else{
      for(annot.name.i in get(arg.i)){
        if(sum(is.na(tmp.annot[annot.name.i]))>0){
          wtmp <- paste(annot.name.i," contains NA for some samples! These samples are ignored in SPD when analyzing relative to",annot.name.i)
          warning(wtmp)
          wtmp <- paste(wtmp,"Warning:",wtmp,"\n")
        }
      }
    }
    
    
  }
  
  #   
  #   
  #   # Evaluate probe.names to keep only those probes that are not filtered out for whatever reason
  #   probe.names.to.describe <- get(RPD.prb.names.arg,envir = tmp.env)
  #   
  #   if(any(!probe.names.to.describe %in% colnames(dat))){
  #     wtmp <- paste(paste(probe.names.to.describe[!probe.names.to.describe %in% colnames(dat)],collapse = ","),"removed in previous analysis steps and will not be included in SPD analysis")
  #     warning(wtmp)
  #     wtmp <- paste(wtmp,"Warning:",wtmp,"\n")
  #     probe.names.to.describe <- probe.names.to.describe[probe.names.to.describe %in% colnames(dat)] 
  #     assign(SPD.prb.names.arg,value = probe.names.to.describe,envir = globalenv())
  #   }
  #   
  
  return(wtmp)
  
}



